<?php

use app\SmsBuilder;
use smpp\SMPP;

require_once 'vendor/autoload.php';
require_once 'app/SMPPBuilder.php';
header("Content-Type: application/json");


if (isset($_POST)) {
    if (isset($_POST['url']) && $_POST['url'] != null) {
        $url = $_POST['url'];
    } else {
        echo json_encode([
                'status'  => 'error',
                'message' => 'IP address or System url required',
        ]);
        exit();
    }

    if (isset($_POST['username']) && $_POST['username'] != null) {
        $username = $_POST['username'];
    } else {
        echo json_encode([
                'status'  => 'error',
                'message' => 'Username or system id required',
        ]);
        exit();
    }


    if (isset($_POST['password']) && $_POST['password'] != null) {
        $password = $_POST['password'];
    } else {
        echo json_encode([
                'status'  => 'error',
                'message' => 'Password required',
        ]);
        exit();
    }


    if (isset($_POST['port']) && $_POST['port'] != null) {
        $port = filter_var($_POST['port'], FILTER_SANITIZE_NUMBER_INT);
    } else {
        echo json_encode([
                'status'  => 'error',
                'message' => 'Port address required',
        ]);
        exit();
    }

    if (isset($_POST['sender_id']) && $_POST['sender_id'] != null) {
        $sender_id = $_POST['sender_id'];
    } else {
        $sender_id = null;
    }

    if (isset($_POST['to']) && $_POST['to'] != null) {
        $to = $_POST['to'];
    } else {
        echo json_encode([
                'status'  => 'error',
                'message' => 'To or destination number required',
        ]);
        exit();
    }

    if (isset($_POST['message']) && $_POST['message'] != null) {
        $message = $_POST['message'];
    } else {
        echo json_encode([
                'status'  => 'error',
                'message' => 'Message required',
        ]);
        exit();
    }

    if (isset($sender_id) && strlen($sender_id) <= 8) {
        $source_ton = SMPP::TON_NETWORKSPECIFIC;
    } elseif (isset($sender_id) && (strlen($sender_id) <= 15 && strlen($sender_id) >= 10)) {
        $source_ton = SMPP::TON_INTERNATIONAL;
    } else {
        $source_ton = SMPP::TON_ALPHANUMERIC;
    }

    try {

// replace address, port, login and password to your values
        $builder = (new SmsBuilder($url, $port, $username, $password, 10000));
        if (isset($sender_id)) {
            $builder->setSender($sender_id, $source_ton);
        }
        $output = $builder->setRecipient($to, SMPP::TON_INTERNATIONAL) //msisdn of recipient
                          ->sendMessage($message);


        if ($output || str_contains($output, '0x6')) {
            echo json_encode([
                    'status'  => 'success',
                    'message' => 'Message send successfully',
            ]);
        } else {
            echo json_encode([
                    'status'  => 'error',
                    'message' => 'Please try again',
            ]);
        }

        exit();

    } catch (Exception $e) {
        echo json_encode([
                'status'  => 'error',
                'message' => $e->getMessage(),
        ]);
        exit();
    }


} else {
    echo json_encode([
            'status'  => 'error',
            'message' => 'Invalid request. Please try again',
    ]);
    exit();
}


