<!DOCTYPE html>
<html lang="en">
<head>
    <title>Ultimate SMS - Test SMPP</title>
    <link href="assets/noty.css" rel="stylesheet">
    <link href="assets/themes/mint.css" rel="stylesheet">
    <link href="assets/style.css" rel="stylesheet">
</head>
<body>

<div id="wrapper">
    <div class="logo">
        <a href="https://ultimatesms.codeglen.com"><img src="https://ultimatesms.codeglen.com/demo/images/logo/92e0ec159fc714ae0118c525a8d484a0.png" alt="Logo"></a>
    </div>
    <h1><a href="https://ultimatesms.codeglen.com">Ultimate SMS</a> - Test SMPP</h1>

    <form name="ultimate-sms-form" action="" method="post" id="ultimate-sms-form">

        <label for="url"><b>IP Address/URL</b></label>
        <input type="text" placeholder="Enter IP Address/Url" name="url" required>

        <label for="username"><b>System ID/Username</b></label>
        <input type="text" placeholder="Enter system id or username" name="username" required>

        <label for="password"><b>Password</b></label>
        <input type="password" placeholder="Enter Password" name="password" required>

        <label for="port"><b>Port</b></label>
        <input type="number" placeholder="Enter Port number" name="port" required>

        <label for="sender_id"><b>From Number/Sender ID</b></label>
        <input type="text" placeholder="Enter Sender ID or From number or Source number" name="sender_id">

        <label for="to"><b>To Number</b></label>
        <input type="text" placeholder="Enter To number or destination number" name="to" required>


        <label for="to"><b>Message</b></label>
        <textarea placeholder="Enter message" rows="5" cols="5" name="message" required></textarea>


        <div class="clearfix">
            <button type="submit" value="submit" name="submit" id="submit_form">Send</button>
        </div>

    </form>

</div>

<script src="assets/jquery.min.js"></script>
<script src="assets/noty.min.js"></script>
<script>
    $(function () {

        let request;

        $("#ultimate-sms-form").on("submit", function (event) {

            // Prevent default posting of form - put here to work in case of errors
            event.preventDefault();

            // Abort any pending request
            if (request) {
                request.abort();
            }
            // setup some local variables
            let $form = $(this);

            // Let's select and cache all the fields
            let $inputs = $form.find("input, button, textarea");

            // Serialize the data in the form
            let serializedData = $form.serialize();

            $inputs.prop("disabled", true);

            // Fire off the request to /form.php
            request = $.ajax({
                url: window.location.href + "/send.php",
                type: "post",
                data: serializedData
            });

            // Callback handler that will be called on success
            request.done(function (response) {
                if (response.status === 'success') {
                    new Noty({
                        type: 'success',
                        layout: 'topRight',
                        text: response.message
                    }).show();
                } else {
                    new Noty({
                        type: 'error',
                        layout: 'topRight',
                        text: response.message
                    }).show();
                }
            });

            // Callback handler that will be called on failure
            request.fail(function (jqXHR, textStatus, errorThrown) {
                new Noty({
                    type: 'error',
                    layout: 'topRight',
                    text: "The following error occurred: " + textStatus, errorThrown
                }).show();
            });

            request.always(function () {
                $inputs.prop("disabled", false);
            });

        });
    });
</script>


</body>
</html>
